/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.lib.block.entity.ICoFHTickableTile;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.block.device.TileBlockComposter;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceComposterContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class DeviceComposterTile
extends DeviceTileBase
implements ICoFHTickableTile.IServerTickable {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Filter");
    protected static int timeConstant = 120;
    protected static boolean particles = true;
    protected static final Supplier<ItemStack> COMPOST = () -> new ItemStack((ItemLike)ThermalCore.ITEMS.get("compost"), 0);
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH(e -> false).setEmptyItem(COMPOST);
    protected boolean hasInputsCache;
    protected float compostLevel;
    protected static final float COMPOST_LEVEL_MAX = 8.0f;
    protected int processMax;
    protected int process = this.processMax = timeConstant;

    public static void setTimeConstant(int configConstant) {
        timeConstant = configConstant;
    }

    public static void setParticles(boolean configConstant) {
        particles = configConstant;
    }

    public DeviceComposterTile(BlockPos pos, BlockState state) {
        super(TCoreReferences.DEVICE_COMPOSTER_TILE, pos, state);
        this.inventory.addSlots(StorageGroup.INPUT, 9, item -> this.filter.valid(item) && ComposterBlock.f_51914_.containsKey((Object)item.m_41720_()));
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
    }

    public void tickServer() {
        this.updateActiveState();
        if (Utils.timeCheck()) {
            this.updateTrackers();
        }
        if (!this.isActive) {
            return;
        }
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.process = this.processMax = timeConstant / (int)this.baseMod;
        if (!this.outputSlot.isFull()) {
            for (ItemStorageCoFH slot : this.inventory.getInputSlots()) {
                if (!ComposterBlock.f_51914_.containsKey((Object)slot.getItemStack().m_41720_())) continue;
                this.compostLevel += ComposterBlock.f_51914_.getFloat((Object)slot.getItemStack().m_41720_());
                slot.consume(1);
            }
            this.hasInputsCache = this.hasInputs();
        }
        while (this.compostLevel >= 8.0f && !this.outputSlot.isFull()) {
            this.compostLevel -= 8.0f;
            this.outputSlot.modify(1);
            if (!particles) continue;
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123749_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, 4, 0.1, 0.0, 0.1, 0.02);
        }
    }

    @Override
    protected boolean isValid() {
        return this.hasInputsCache;
    }

    protected void updateTrackers() {
        int scaledOutput = 8 * this.outputSlot.getCount() / this.outputSlot.getCapacity();
        if (this.f_58857_ != null && scaledOutput != (Integer)this.m_58900_().m_61143_((Property)TileBlockComposter.LEVEL)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TileBlockComposter.LEVEL, (Comparable)Integer.valueOf(scaledOutput)));
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceComposterContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.outputSlot.isFull() || !this.hasInputsCache) {
            return 0;
        }
        return scale * (this.processMax - this.process) / this.processMax;
    }

    protected boolean hasInputs() {
        for (ItemStorageCoFH slot : this.inventory.getInputSlots()) {
            if (slot.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.processMax);
        buffer.writeBoolean(this.hasInputsCache);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.process = buffer.readInt();
        this.processMax = buffer.readInt();
        this.hasInputsCache = buffer.readBoolean();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.process = nbt.m_128451_("Proc");
        this.processMax = nbt.m_128451_("ProcMax");
        this.hasInputsCache = this.hasInputs();
        this.compostLevel = nbt.m_128457_("Compost");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Proc", this.process);
        nbt.m_128405_("ProcMax", this.processMax);
        nbt.m_128350_("Compost", this.compostLevel);
    }

    @Override
    public void onInventoryChanged(int slot) {
        if (this.f_58857_ != null && Utils.isServerWorld((Level)this.f_58857_) && slot <= 8) {
            this.hasInputsCache = this.hasInputs();
            if (!this.hasInputsCache) {
                this.process = this.processMax = timeConstant / (int)this.baseMod;
            }
        }
        super.onInventoryChanged(slot);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void updateHandlers() {
        LazyOptional prevItemCap = this.itemCap;
        IItemHandler invHandler = this.inventory.getHandler(StorageGroup.INPUT_OUTPUT);
        this.itemCap = this.inventory.hasAccessibleSlots() ? LazyOptional.of(() -> invHandler) : LazyOptional.empty();
        prevItemCap.invalidate();
    }

    @Override
    protected <T> LazyOptional<T> getItemHandlerCapability(@javax.annotation.Nullable Direction side) {
        if (!this.itemCap.isPresent() && this.inventory.hasAccessibleSlots()) {
            IItemHandler handler = this.inventory.getHandler(StorageGroup.INPUT_OUTPUT);
            this.itemCap = LazyOptional.of(() -> handler);
        }
        return this.itemCap.cast();
    }
}

